{*********************************************************}
{*		    MROUNIT1.PAS 2.00			 *}
{*     Copyright (c) Tamarack Associates 1995, 1996.	 *}
{*		   All rights reserved. 		 *}
{*********************************************************}

{$I TADBMRO.INC}


unit MROUnit1;

interface

uses
  {$IFDEF WIN32}
  Windows,
  {$ELSE}
  WinTypes,
  {$ENDIF}
  SysUtils, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, StdCtrls, Mask, ExtCtrls, DBTables,
  Grids, DBGrids, DBCtrls, Tabs,
  {$IFDEF UseInfoPower}
  wwTable, wwDatSrc, wwDBIGrd, wwDBGrid, wwDBComb,
  {$ENDIF}
  {$IFDEF UseTwwDBLookupCombo}
  wwDBLook,
  {$ENDIF}
  {$IFDEF UseTwwDBLookupComboDlg}
  wwDBDlg,
  {$ENDIF}
  {$IFDEF UseTDBComboBoxPlus}
  Dblup1b,
  {$ENDIF}
  {$IFDEF UseTDBLookupComboPlus}
  Dblup2,
  {$ENDIF}
  DBLookup,
  {$IFDEF UseOrpheus}
  OvcPB, OvcNF, OvcDbNf, OvcBase, OvcEF, OvcSF,
  OvcDbSf, OvcPF, OvcDbPf, OvcCaret,
  {$ENDIF}
  taDBMRO;
type
  TForm1 = class(TForm)
    TabSet1: TTabSet;
    Notebook1: TNotebook;
    FontDialog1: TFontDialog;
    ColorDialog1: TColorDialog;

    {* Introduction *}
    IntroPanel: TPanel;
    IntroMemo: TMemo;
    IntroTAPanel: TPanel;
     IntroTALabel1: TLabel;
     IntroTALabel2: TLabel;
     IntroTALabel3: TLabel;

    {* Main Demo *}
    MainMRO: TtaDBMRO;
    MainDBNavigator: TDBNavigator;
    MainRecordPanel: TPanel;
     DBEdit1: TDBEdit;
     DBEdit2: TDBEdit;
     DBEdit3: TDBEdit;
     DBEdit4: TDBEdit;
     DBEdit5: TDBEdit;
     DBEdit6: TDBEdit;
     DBEdit7: TDBEdit;
     DBEdit8: TDBEdit;
     DBEdit9: TDBEdit;
     DBEdit10: TDBEdit;
     DBEdit11: TDBEdit;
     DBText1: TDBText;
     MainRecordLabel: TLabel;
     MainRecordBevel: TBevel;
     MainRecordGroupBox: TGroupBox;
    MainTitlePanel: TPanel;
     TitleLabel1: TLabel;
     TitleLabel2: TLabel;
     TitleLabel3: TLabel;
     TitleLabel4: TLabel;
     TitleLabel6: TLabel;
     TitleLabel5: TLabel;
     TitleLabel7: TLabel;
     TitleLabel8: TLabel;
     TitleLabel9: TLabel;
     TitleLabel10: TLabel;
     TitleLabel11: TLabel;
    MainTAPanel: TPanel;
     MainTALabel1: TLabel;
     MainTALabel2: TLabel;
     MainTALabel3: TLabel;
    MainOptionsGroupBox: TGroupBox;
     BorderStyleCheckBox: TCheckBox;
     IndicatorCheckBox: TCheckBox;
     RowLinesCheckBox: TCheckBox;
     OnDrawBackgroundCheckBox: TCheckBox;
     MROColorCheckBox: TCheckBox;
     TitlesCheckBox: TCheckBox;
     AutoHeightCheckBox: TCheckBox;
     AutoWidthCheckBox: TCheckBox;
     TabCheckBox: TCheckBox;
     UseColorCheckBox: TCheckBox;
     UseFontCheckBox: TCheckBox;

    {* Box Demo *}
    BoxMRO: TtaDBMRO;
    BoxRecordPanel: TPanel;
     OrderNoLabel: TLabel;
     OrderNoDBEdit: TDBEdit;
     CompanyLabel: TLabel;
     DBLookupCombo1: TDBLookupCombo;
     TermsLabel: TLabel;
     DBComboBox1: TDBComboBox;
     DBCheckBox1: TDBCheckBox;
     EmployeeLabel: TLabel;
     DBLookupList1: TDBLookupList;
     PaymentLabel: TLabel;
     DBListBox1: TDBListBox;
     DBRadioGroup1: TDBRadioGroup;
    xdAllGroupBox: TGroupBox;
    xdCtl3dCheckBox: TCheckBox;
     xdEnabledCheckBox: TCheckBox;
     xdColorBtn: TButton;
     xdFontBtn: TButton;
    xdLabelGroupBox: TGroupBox;
     xdLabelJustifyComboBox: TComboBox;
     xdLabelTransparentCheckBox: TCheckBox;
     xdLabelAccelCharCheckBox2: TCheckBox;
    xdPanelGroupBox: TGroupBox;
     xdPanelComboBox: TComboBox;
     xdPanelLabel: TLabel;
     xdBevelInnerComboBox: TComboBox;
     xdPanelLabel2: TLabel;
     xdBevelOuterComboBox: TComboBox;
     xdPanelLabel3: TLabel;
     xdPanelScrollBar1: TScrollBar;
     xdPanelLabel4: TLabel;
     xdPanelScrollBar2: TScrollBar;
    xdEditGroupBox: TGroupBox;
     xdLookupListLabel: TLabel;
     xdEditBorderStyleComboBox: TComboBox;
    BlobMRO: TtaDBMRO;
    BlobRecordPanel: TPanel;
     SpeciesDBEdit: TDBEdit;
     CommonNameDBText: TDBText;
     DBMemo1: TDBMemo;
     DBImage1: TDBImage;
    bdAllGroupBox: TGroupBox;
    bdCtl3DCheckBox: TCheckBox;
     bdBorderStyleComboBox: TComboBox;
     bdFontBtn: TButton;
     bdColorBtn: TButton;
    bdEditGroupBox: TGroupBox;
    bdEditAlignComboBox: TComboBox;
    bdTextGroupBox: TGroupBox;
    bdTextTransparentCheckBox: TCheckBox;
    bdMemoGroupBox: TGroupBox;
    bdMemoAutoDisplayCheckBox: TCheckBox;
    bdMemoWordWrapCheckBox: TCheckBox;
    bdMemoAlignComboBox: TComboBox;
    bdMemoScrollBarComboBox: TComboBox;
    bdImageGroupBox: TGroupBox;
    bdImageAutoDisplayCheckBox: TCheckBox;
    bdImageStretchCheckBox: TCheckBox;

    {* Third Party *}
    ThirdMRO: TtaDBMRO;
    tpAllControlsGroupBox: TGroupBox;
     tpCtl3DCheckBox: TCheckBox;
     tpEnabledCheckBox: TCheckBox;
     tpBorderStyleComboBox: TComboBox;
     tpColorBtn: TButton;
     tpFontBtn: TButton;
    tpCombosGroupBox: TGroupBox;
     tpHideButtonCheckBox: TCheckBox;
    ThirdPanel: TPanel;
     {* InfoPower *}
     InfoPowerGroupBox: TGroupBox;
      wwLabel1: TLabel;
      wwLabel2: TLabel;

     {* Out & About Productions *}
     OutAboutGroupBox: TGroupBox;
      PlusLabel1: TLabel;
      PlusLabel2: TLabel;

     {* Orpheus Controls *}
     OrpheusGroupBox: TGroupBox;
      OvcLabel1: TLabel;
      OvcLabel2: TLabel;
      OvcLabel3: TLabel;

    {* Data Access Controls *}
    CustomerDataSource: TDataSource;
    CustomerTable: TTable;
    OrdersDataSource: TDataSource;
    OrdersTable: TTable;
    BioLifeDataSource: TDataSource;
    BioLifeTable: TTable;
    EmployeeDataSource: TDataSource;
    EmployeeTable: TTable;

    CustomerTableCustNo: TFloatField;
    CustomerTableCompany: TStringField;
    CustomerTableAddr1: TStringField;
    CustomerTableAddr2: TStringField;
    CustomerTableCity: TStringField;
    CustomerTableState: TStringField;
    CustomerTableZip: TStringField;
    CustomerTableCountry: TStringField;
    CustomerTablePhone: TStringField;
    CustomerTableFAX: TStringField;
    CustomerTableTaxRate: TFloatField;
    CustomerTableContact: TStringField;
    CustomerTableLastInvoiceDate: TDateTimeField;

    BioLifeTableCommon_Name: TStringField;
    BioLifeTableSpeciesName: TStringField;
    BioLifeTableNotes: TMemoField;
    BioLifeTableGraphic: TGraphicField;

    OrdersTableOrderNo: TFloatField;
    OrdersTableCustNo: TFloatField;
    OrdersTableSaleDate: TDateTimeField;
    OrdersTableShipDate: TDateTimeField;
    OrdersTableEmpNo: TIntegerField;
    OrdersTableShipVIA: TStringField;
    OrdersTableTerms: TStringField;
    OrdersTablePaymentMethod: TStringField;
    OrdersTableShipToContact: TStringField;
    OrdersTableAmountPaid: TCurrencyField;

    EmployeeTableEmpNo: TIntegerField;
    EmployeeTableLastName: TStringField;
    xdCheckBoxGroupBox: TGroupBox;
    xdCheckBoxJustifyComboBox1: TComboBox;
    InfoCheckBox: TCheckBox;
    procedure Notebook1PageChanged(Sender: TObject);
    procedure TabSet1Change(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure DBEdit1Exit(Sender: TObject);
    procedure DBEdit11Exit(Sender: TObject);
    procedure MainMRODrawBackground(Sender: TObject; Control: TControl;
      const CellRect: TRect);

    procedure IndicatorCheckBoClick(Sender: TObject);
    procedure RowLinesCheckBoxClick(Sender: TObject);
    procedure OnDrawBackgroundCheckBoxClick(Sender: TObject);
    procedure MROColorCheckBoxClick(Sender: TObject);
    procedure TitlesCheckBoxClick(Sender: TObject);
    procedure AutoWidthCheckBoxClick(Sender: TObject);
    procedure AutoHeightCheckBoxClick(Sender: TObject);
    procedure UseColorCheckBoxClick(Sender: TObject);
    procedure UseFontCheckBoxClick(Sender: TObject);
    procedure MainRecordPanelClick(Sender: TObject);

    procedure xdCtl3dCheckBoxClick(Sender: TObject);
    procedure xdEnabledCheckBoxClick(Sender: TObject);
    procedure xdColorBtnClick(Sender: TObject);
    procedure xdFontBtnClick(Sender: TObject);
    procedure xdEditBorderStyleComboBoxChange(Sender: TObject);
    procedure xdLabelJustifyComboBoxChange(Sender: TObject);
    procedure xdLabelTransparentCheckBoxClick(Sender: TObject);
    procedure xdLabelAccelCharCheckBox2Click(Sender: TObject);
    procedure xdPanelComboBoxChange(Sender: TObject);
    procedure xdBevelInnerComboBoxChange(Sender: TObject);
    procedure xdBevelOuterComboBoxChange(Sender: TObject);
    procedure xdPanelScrollBar1Change(Sender: TObject);
    procedure xdPanelScrollBar2Change(Sender: TObject);
    procedure BlobRecordPanelClick(Sender: TObject);

    procedure bdCtl3DCheckBoxClick(Sender: TObject);
    procedure bdBorderStyleComboBoxChange(Sender: TObject);
    procedure bdFontBtnClick(Sender: TObject);
    procedure bdColorBtnClick(Sender: TObject);
    procedure bdEditAlignComboBoxChange(Sender: TObject);
    procedure bdMemoAutoDisplayCheckBoxClick(Sender: TObject);
    procedure bdMemoAlignComboBoxChange(Sender: TObject);
    procedure bdMemoWordWrapCheckBoxClick(Sender: TObject);
    procedure bdMemoScrollBarComboBoxChange(Sender: TObject);
    procedure bdImageAutoDisplayCheckBoxClick(Sender: TObject);
    procedure bdImageStretchCheckBoxClick(Sender: TObject);
    procedure bdTextTransparentCheckBoxClick(Sender: TObject);
    procedure BoxRecordPanelClick(Sender: TObject);

    procedure tpCtl3DCheckBoxClick(Sender: TObject);
    procedure tpEnabledCheckBoxClick(Sender: TObject);
    procedure tpBorderStyleComboBoxChange(Sender: TObject);
    procedure tpColorBtnClick(Sender: TObject);
    procedure xdCheckBoxJustifyComboBox1Change(Sender: TObject);
    procedure BioLifeTableAfterInsert(DataSet: TDataset);
    procedure BioLifeTableBeforePost(DataSet: TDataset);
    procedure tpHideButtonCheckBoxClick(Sender: TObject);
    procedure tpFontBtnClick(Sender: TObject);
    procedure BorderStyleCheckBoxClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    {$IFDEF UseTwwDBLookupCombo}
    wwDBLookupCombo1: TwwDBCustomLookupCombo;
    {$ENDIF}
    {$IFDEF UseInfoPower}
    wwDBComboBox1: TwwDBComboBox;
    {$ENDIF}
    {$IFDEF UseTOvcDBSimpleField}
    OvcDbSimpleField1: TOvcDbSimpleField;
    {$ENDIF}
    {$IFDEF UseTOvcDBPictureField}
    OvcDbPictureField1: TOvcDbPictureField;
    {$ENDIF}
    {$IFDEF UseTOvcDBNumericField}
    OvcDbNumericField1: TOvcDbNumericField;
    {$ENDIF}
    {$IFDEF UseOrpheus}
    OvcController1: TOvcController;
    {$ENDIF}
    {$IFDEF UseTDBLookupComboPlus}
    DBLookupComboPlus1 : TDBLookupComboPlus;
    {$ENDIF}
    {$IFDEF UseTDBComboBoxPlus}
    DBComboBoxPlus1 : TDBComboBoxPlus;
    {$ENDIF}
    {$IFDEF UseTDBLookupComboBox}
    DBLookupComboBox1: TDBLookupComboBox;
    {$ENDIF}
    {$IFDEF UseTDBLookupListBox}
    DBLookupListBox1: TDBLookupListBox;
    {$ENDIF}
    PROCEDURE WMParentNotify(VAR Msg : TWMParentNotify) ; MESSAGE WM_PARENTNOTIFY;
  protected
    { Protected declarations }
    PROCEDURE ActiveChanged ; OVERRIDE;
    PROCEDURE CreateThirdParty;
    PROCEDURE FreeThirdParty;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


FUNCTION CheckForTables : BOOLEAN;
VAR	 List : TStrings;

 PROCEDURE FindTable(T : STRING);
 BEGIN
  IF List.IndexOf(T) < 0 THEN
   BEGIN
    Result := FALSE;
    MessageDlg('Table ' + T + ' not found',mtError,[mbOk],0)
   END
 END;

BEGIN
 Result := FALSE;
 List := TStringList.Create;
 TRY
  Session.GetAliasNames(List);
  IF List.IndexOf('DBDEMOS') < 0 THEN
   MessageDlg('Could not find alias DBDEMOS',mtError,[mbOk],0)
  ELSE
   BEGIN
    Result := TRUE;
    Session.GetTableNames('DBDEMOS','*.DB',FALSE,FALSE,List);
    FindTable('CUSTOMER');
    FindTable('ORDERS');
    FindTable('EMPLOYEE');
    FindTable('BIOLIFE')
   END
 FINALLY
  List.Free
 END
END;

CONST iAutoDisplay : STRING = 'Autodisplay for the current record does not take'+
			      ' affect until you move off the record';

PROCEDURE FYI(VAR S : STRING);
BEGIN
 IF (LENGTH(S) > 0) AND Form1.InfoCheckBox.Checked THEN
  BEGIN
   MessageDlg(S,mtInformation,[mbOk],0);
   S := ''
  END
END;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
VAR F : TForm;
begin
 CASE Notebook1.PageIndex OF
  1 : MainMRO.FormKeyDown(ActiveControl,Key,Shift);
  2 : BoxMRO.FormKeyDownExt(ActiveControl,Key,Shift);
  3 : BlobMRO.FormKeyDownExt(ActiveControl,Key,Shift);
  4 : ThirdMRO.FormKeyDownExt(ActiveControl,Key,Shift);
 END
end;

{* Routine needed to implement Tabbing to next/prior record *}

PROCEDURE TForm1.WMParentNotify(VAR Msg : TWMParentNotify);
BEGIN
 MainMRO.MonitorFocus(Msg.Event);
 INHERITED
END;

{* Routine needed to implement Tabbing to next/prior record *}

PROCEDURE TForm1.ActiveChanged;
BEGIN
 MainMRO.MonitorFocus(WM_SETFOCUS);
 {* The inherited routine is empty, so no real need to call it *}
 INHERITED ActiveChanged
END;

procedure TForm1.BorderStyleCheckBoxClick(Sender: TObject);
begin
 WITH Sender AS TCheckBox DO
  WITH MainMRO DO
   IF Checked THEN BorderStyle := bsSingle
   ELSE BorderStyle := bsNone
end;

procedure TForm1.IndicatorCheckBoClick(Sender: TObject);
begin
 WITH MainMRO DO
  BEGIN
   IF dgIndicator IN Options THEN
    Options := Options - [dgIndicator]
   ELSE
    Options := Options + [dgIndicator]
  END
end;

procedure TForm1.RowLinesCheckBoxClick(Sender: TObject);
begin
 WITH MainMRO DO
  IF dgRowLines IN Options THEN
   Options := Options - [dgRowLines]
  ELSE
   Options := Options + [dgRowLines]
end;

procedure TForm1.MainMRODrawBackground(Sender: TObject; Control: TControl;
  const CellRect: TRect);
begin
 WITH MainMRO.Canvas DO
  BEGIN
   Brush.Color := clBtnFace;
   FillRect(CellRect)
  END
end;

procedure TForm1.OnDrawBackgroundCheckBoxClick(Sender: TObject);
begin
 WITH MainMRO DO
  BEGIN
   IF (Sender AS TCheckBox).Checked THEN
    OnDrawBackground := MainMRODrawBackground
   ELSE OnDrawBackground := NIL;
   Invalidate
  END
end;

procedure TForm1.TitlesCheckBoxClick(Sender: TObject);
begin
 WITH MainMRO DO
  IF dgTitles IN Options THEN
   Options := Options - [dgTitles]
  ELSE
   Options := Options + [dgTitles]
end;

procedure TForm1.AutoHeightCheckBoxClick(Sender: TObject);
begin
 WITH MainMRO DO
  BEGIN
   AutoHeight := NOT AutoHeight;
   IF NOT AutoHeight THEN Height := Height + 26
  END
end;

procedure TForm1.AutoWidthCheckBoxClick(Sender: TObject);
begin
 WITH MainMRO DO
  BEGIN
   AutoWidth := NOT AutoWidth;
   IF NOT AutoWidth THEN Width := Width + 3
  END
end;

procedure TForm1.MROColorCheckBoxClick(Sender: TObject);
begin
 WITH MainMRO DO
  IF Color = RecordPanel.Color THEN Color := clAqua
  ELSE Color := RecordPanel.Color
end;

procedure TForm1.UseColorCheckBoxClick(Sender: TObject);
begin
 WITH MainMRO DO
  UseColor := NOT UseColor;
end;

procedure TForm1.UseFontCheckBoxClick(Sender: TObject);
begin
 WITH MainMRO DO
  UseFont := NOT UseFont
end;

procedure TForm1.TabSet1Change(Sender: TObject; NewTab: Integer;
  var AllowChange: Boolean);
begin
 AllowChange := TRUE;
 Notebook1.PageIndex := NewTab
end;

{* Routine needed to implement Tabbing to next/prior record *}

procedure TForm1.DBEdit1Exit(Sender: TObject);
begin
 IF TabCheckBox.Checked THEN
  MainMRO.FieldOnExit(ActiveControl,UseFontCheckBox,DBEdit11,FALSE)
end;

{* Routine needed to implement Tabbing to next/prior record *}

procedure TForm1.DBEdit11Exit(Sender: TObject);
begin
 IF TabCheckBox.Checked THEN
  MainMRO.FieldOnExit(ActiveControl,BorderStyleCheckBox,DBEdit1,TRUE)
end;

procedure TForm1.MainRecordPanelClick(Sender: TObject);
begin
 IF DBEdit1.Enabled THEN DBEdit1.SetFocus
end;

procedure TForm1.bdMemoAutoDisplayCheckBoxClick(Sender: TObject);
begin
 WITH DBMemo1 DO
  AutoDisplay := NOT AutoDisplay;
 BlobMRO.Invalidate;
 FYI(iAutoDisplay)
end;

procedure TForm1.bdImageAutoDisplayCheckBoxClick(Sender: TObject);
begin
 WITH DBImage1 DO
  AutoDisplay := NOT AutoDisplay;
 BlobMRO.Invalidate;
 FYI(iAutoDisplay)
end;

procedure TForm1.bdCtl3DCheckBoxClick(Sender: TObject);
begin
 WITH Sender AS TCheckBox DO
  BEGIN
   BlobRecordPanel.Ctl3D := Checked;
 { BlobMRO.Ctl3D := Checked }
  END;
 BlobMRO.Invalidate
end;

procedure TForm1.bdImageStretchCheckBoxClick(Sender: TObject);
begin
 WITH DBImage1 DO Stretch := NOT Stretch;
 BlobMRO.Invalidate
end;

procedure TForm1.bdMemoAlignComboBoxChange(Sender: TObject);
begin
 WITH Sender AS TComboBox DO
  DBMemo1.Alignment := TAlignment(ItemIndex);
 BlobMRO.Invalidate
end;

procedure TForm1.bdMemoScrollBarComboBoxChange(Sender: TObject);
begin
 WITH DBMemo1, Sender AS TComboBox DO
  ScrollBars := TScrollStyle(ItemIndex);
 BlobMRO.Invalidate
end;

procedure TForm1.bdFontBtnClick(Sender: TObject);
begin
 WITH FontDialog1 DO
  BEGIN
   Font := BlobRecordPanel.Font;
   IF Execute THEN BlobRecordPanel.Font := Font
  END;
 BlobMRO.Perform(CM_FontChanged,0,0);
 BlobMRO.Invalidate
end;

procedure TForm1.bdColorBtnClick(Sender: TObject);
begin
 WITH ColorDialog1 DO
  BEGIN
   Color := SpeciesDBEdit.Color;
   IF Execute THEN
    BEGIN
     SpeciesDBEdit.Color := Color;
    {CommonNameEdit.Color := Color;}
     DBMemo1.Color := Color;
     DBImage1.Color := Color
    END
  END;
 BlobMRO.Invalidate
end;

procedure TForm1.bdEditAlignComboBoxChange(Sender: TObject);
begin
 WITH Sender AS TComboBox DO
  BEGIN
   CommonNameDBText.Alignment	     := TAlignment(ItemIndex);
   BioLifeTableSpeciesName.Alignment := TAlignment(ItemIndex)
  END;
 BlobMRO.Invalidate
end;

procedure TForm1.xdCtl3dCheckBoxClick(Sender: TObject);
begin
 WITH Sender AS TCheckBox DO
  BEGIN
   BoxRecordPanel.Ctl3D := Checked;
 { BoxMRO.Ctl3D := Checked }
  END;
 BoxMRO.Invalidate
end;

procedure TForm1.xdFontBtnClick(Sender: TObject);
begin
 WITH FontDialog1 DO
  BEGIN
   Font := BoxRecordPanel.Font;
   IF Execute THEN BoxRecordPanel.Font := Font
  END;
 BoxMRO.Perform(CM_FontChanged,0,0);
 BoxMRO.Invalidate
end;

procedure TForm1.xdEditBorderStyleComboBoxChange(Sender: TObject);
begin
 WITH Sender AS TComboBox DO
  BEGIN
   OrderNoDBEdit.BorderStyle := TBorderStyle(ItemIndex);
   DBListBox1.BorderStyle    := TBorderStyle(ItemIndex);
   {$IFDEF UseTDBLookupListBox}
   DBLookupListBox1.BorderStyle := TBorderStyle(ItemIndex);
   {$ELSE}
   DBLookupList1.BorderStyle := TBorderStyle(ItemIndex);
   {$ENDIF}
   BoxMRO.BorderStyle	     := TBorderStyle(ItemIndex)
  END;
{BoxMRO.Invalidate}
end;

procedure TForm1.xdColorBtnClick(Sender: TObject);
begin
 WITH ColorDialog1 DO
  BEGIN
   Options := [cdPreventFullOpen];
   Color := OrderNoDBEdit.Color;
   IF Execute THEN
    BEGIN
     OrderNoDBEdit.Color := Color;
     {$IFDEF UseTDBLookupComboBox}
     DBLookupComboBox1.Color := Color;
     {$ELSE}
     DBLookupCombo1.Color := Color;
     {$ENDIF}
     {$IFDEF UseTDBLookupListBox}
     DBLookupListBox1.Color := Color;
     {$ELSE}
     DBLookupList1.Color := Color;
     {$ENDIF}
     DBComboBox1.Color := Color;
     DBListBox1.Color := Color;
     DBRadioGroup1.Color := Color
    END
  END;
 BoxMRO.Invalidate
end;

procedure TForm1.xdLabelJustifyComboBoxChange(Sender: TObject);
begin
 WITH Sender AS TComboBox DO
 OrderNoLabel.Alignment  := TAlignment(ItemIndex);
 CompanyLabel.Alignment  := OrderNoLabel.Alignment;
 EmployeeLabel.Alignment := OrderNoLabel.Alignment;
 TermsLabel.Alignment	 := OrderNoLabel.Alignment;
 PaymentLabel.Alignment  := OrderNoLabel.Alignment;
 BoxMRO.Invalidate
end;

procedure TForm1.xdPanelComboBoxChange(Sender: TObject);
begin
 BoxRecordPanel.BorderStyle := TBorderStyle((Sender AS TComboBox).ItemIndex);
 BoxMRO.Invalidate
end;

procedure TForm1.xdBevelInnerComboBoxChange(Sender: TObject);
begin
 BoxRecordPanel.BevelInner := TPanelBevel((Sender AS TComboBox).ItemIndex);
 BoxMRO.Invalidate
end;

procedure TForm1.xdBevelOuterComboBoxChange(Sender: TObject);
begin
 BoxRecordPanel.BevelOuter := TPanelBevel((Sender AS TComboBox).ItemIndex);
 BoxMRO.Invalidate
end;

procedure TForm1.xdPanelScrollBar1Change(Sender: TObject);
begin
 WITH Sender AS TScrollBar DO
  BoxRecordPanel.BevelWidth := Position;
 BoxMRO.Invalidate
end;

procedure TForm1.xdPanelScrollBar2Change(Sender: TObject);
begin
 WITH Sender AS TScrollBar DO
  BoxRecordPanel.BorderWidth := Position;
 BoxMRO.Invalidate
end;

procedure TForm1.xdEnabledCheckBoxClick(Sender: TObject);
CONST iEnabled : STRING = 'Not all controls have a uniform appearance when not Enabled';
begin
 WITH Sender AS TCheckBox DO
  BEGIN
   OrderNoDBEdit.Enabled  := Checked;
   {$IFDEF UseTDBLookupComboBox}
   DBLookupComboBox1.Enabled := Checked;
   {$ELSE}
   DBLookupCombo1.Enabled := Checked;
   {$ENDIF}
   {$IFDEF UseTDBLookupListBox}
   DBLookupListBox1.Enabled  := Checked;
   {$ELSE}
   DBLookupList1.Enabled  := Checked;
   {$ENDIF}
   DBComboBox1.Enabled	  := Checked;
   DBListBox1.Enabled	  := Checked;
   DBRadioGroup1.Enabled  := Checked;
   DBCheckBox1.Enabled	  := Checked;
   OrderNoLabel.Enabled   := Checked;
   CompanyLabel.Enabled   := Checked;
   TermsLabel.Enabled	  := Checked;
   EmployeeLabel.Enabled  := Checked;
   PaymentLabel.Enabled   := Checked
  END;
 BoxMRO.Invalidate;
 FYI(iEnabled);
end;

procedure TForm1.BoxRecordPanelClick(Sender: TObject);
begin
 IF OrderNoDBEdit.Enabled THEN OrderNoDBEdit.SetFocus
end;

PROCEDURE TForm1.CreateThirdParty;
VAR	  Count : INTEGER;
BEGIN
 Count := 0;
 {$IFDEF UseTwwDBLookupCombo}
 wwDBLookupCombo1 := TwwDBLookupCombo.Create(Self);
 WITH wwDBLookupCombo1 DO
  BEGIN
   Parent := InfoPowerGroupBox;
   Hint := 'TwwDBLookupCombo';
   Left := 8;
   Top := 32;
   Width := 145;
   Height := 25;
   DropDownAlignment := taLeftJustify;
   Selected.Add('Company'#9'30'#9'Company');
   DataField := 'CustNo';
   DataSource := OrdersDataSource;
   LookupTable := CustomerTable;
   LookupField := 'CustNo';
   TabOrder := Count;
   AutoDropDown := False;
   ShowButton := True;
  END;
 INC(Count);
 {$ENDIF}
 {$IFDEF UseInfoPower}
 wwDBComboBox1 := TwwDBComboBox.Create(Self);
 WITH wwDBComboBox1 DO
  BEGIN
   Parent := InfoPowerGroupBox;
   Hint := 'TwwDBComboBox';
   Left := 8;
   Top := 80;
   Width := 145;
   Height := 25;
   DataField := 'ShipVIA';
   DataSource := OrdersDataSource;
   ItemHeight := 16;
   Items.Add('DHL');
   Items.Add('Emery');
   Items.Add('FedEx');
   Items.Add('UPS');
   Items.Add('US Mail');
   TabOrder := Count;
  END;
 {$ENDIF}
 {$IFDEF UseOrpheus}
 OrdersTable.Close;
 OvcController1 := TOvcController.Create(Self);
 {$ENDIF}
 Count := 0;
 {$IFDEF UseTOvcDBSimpleField}
 OvcDBSimpleField1 := TOvcDBSimpleField.Create(Self);
 WITH OvcDBSimpleField1 DO
  BEGIN
   Parent := OrpheusGroupBox;
   Hint := 'TOvcDBSimpleField';
   Left := 8;
   Top := 27;
   Width := 129;
   Height := 21;
   Cursor := crIBeam;
   DataField := 'ShipVIA';
   DataSource := OrdersDataSource;
   FieldType := ftString;
   CaretOvr.Shape := csBlock;
   Controller := OvcController1;
   ErrorColors.BackColor := clRed;
   ErrorColors.TextColor := clBlack;
   Font.Color := clBlack;
   Font.Height := -11;
   Font.Name := 'Arial';
   Font.Style := [];
   HighlightColors.BackColor := clHighlight;
   HighlightColors.TextColor := clHighlightText;
   MaxLength := 7;
   ParentFont := False;
   TabOrder := Count;
  END;
  INC(Count);
 {$ENDIF}
 {$IFDEF UseTOvcDBPictureField}
 OvcDBPictureField1 := TOvcDBPictureField.Create(Self);
 WITH OvcDBPictureField1 DO
  BEGIN
   Parent := OrpheusGroupBox;
   Hint := 'TOvcDBPictureField';
   Left := 8;
   Top := 65;
   Width := 129;
   Height := 21;
   Cursor := crIBeam;
   DataField := 'PaymentMethod';
   DataSource := OrdersDataSource;
   FieldType := ftString;
   CaretOvr.Shape := csBlock;
   Controller := OvcController1;
   ErrorColors.BackColor := clRed;
   ErrorColors.TextColor := clBlack;
   Font.Color := clBlack;
   Font.Height := -11;
   Font.Name := 'Arial';
   Font.Style := [];
   HighlightColors.BackColor := clHighlight;
   HighlightColors.TextColor := clHighlightText;
   MaxLength := 10;
   ParentFont := False;
   PictureMask := '!!!!!!!!!!';
   RightJustify := True;
   TabOrder := Count;
  END;
 INC(Count);
 {$ENDIF}
 {$IFDEF UseTOvcDBNumericField}
 OvcDBNumericField1 := TOvcDBNumericField.Create(Self);
 WITH OvcDBNumericField1 DO
  BEGIN
   Parent := OrpheusGroupBox;
   Hint := 'TOvcDBNumericField';
   Left := 8;
   Top := 102;
   Width := 129;
   Height := 21;
   Cursor := crIBeam;
   DataField := 'AmountPaid';
   DataSource := OrdersDataSource;
   FieldType := ftCurrency;
   CaretOvr.Shape := csBlock;
   Controller := OvcController1;
   ErrorColors.BackColor := clRed;
   ErrorColors.TextColor := clBlack;
   Font.Color := clBlack;
   Font.Height := -11;
   Font.Name := 'Arial';
   Font.Style := [];
   HighlightColors.BackColor := clHighlight;
   HighlightColors.TextColor := clHighlightText;
   ParentFont := False;
   PictureMask := '$###,###.##';
   TabOrder := Count;
  END;
 {$ENDIF}
 Count := 0;
 {$IFDEF UseOrpheus}
 OrdersTable.Open;
 {$ENDIF}
 {$IFDEF UseTDBLookupComboPlus}
 DBLookupComboPlus1 := TDBLookupComboPlus.Create(Self);
 WITH DBLookupComboPlus1 DO
  BEGIN
   Parent := OutAboutGroupBox;
   Hint := 'TDBLookupComboPlus';
   Left := 8;
   Top := 32;
   Width := 145;
   Height := 25;
   DataField := 'EmpNo';
   DataSource := OrdersDataSource;
   LookupSource := EmployeeDataSource;
   LookupDisplay := 'LastName';
   LookupField := 'EmpNo';
   LookupIndex := 'byName';
   ListColor := clWindow;
   ListFont.Color := clWindowText;
   ListFont.Height := -13;
   ListFont.Name := 'System';
   ListFont.Style := [];
   ListCursor := crDefault;
   ButtonCursor := crDefault;
   Style := DBLUP2.csIncSearch;
   TabOrder := Count;
  END;
 INC(Count);
 {$ENDIF}
 {$IFDEF UseTDBComboBoxPlus}
 DBComboBoxPlus1 := TDBComboBoxPlus.Create(Self);
 WITH DBComboBoxPlus1 DO
  BEGIN
   Parent := OutAboutGroupBox;
   Hint := 'TDBComboBoxPlus';
   Left := 8;
   Top := 80;
   Width := 145;
   Height := 25;
 { DropDownAlign := TLeftRight.Left; }
   LookupActive := True;
   ListColor := clWindow;
   ListDefaultDrawing := True;
   ListFont.Color := clWindowText;
   ListFont.Height := -13;
   ListFont.Name := 'System';
   ListFont.Style := [];
   TitleColor := clBtnFace;
   DataField := 'ShipVIA';
   DataSource := OrdersDataSource;
   Style := DBLUP1A.csIncSearch;
   TabOrder := Count;

   ClearGridData;
   RowCount := 6;
   ColCount := 2;
   AddRow(['DHL'    ,'DHL Worldwide Express']);
   AddRow(['Emery'  ,'Emery Worldwide']);
   AddRow(['FedEx'  ,'Federal Express']);
   AddRow(['UPS'    ,'United Parcel Service']);
   AddRow(['US Mail','United States Mail']);
   SizeGridToData
  END
 {$ENDIF}
END;

PROCEDURE TForm1.FreeThirdParty;
BEGIN
 {$IFDEF UseTwwDBLookupCombo}
 wwDBLookupCombo1.Free;
 wwDBLookupCombo1 := NIL;
 {$ENDIF}
 {$IFDEF UseInfoPower}
 wwDBComboBox1.Free;
 wwDBComboBox1 := NIL;
 {$ENDIF}
 {$IFDEF UseTOvcDBSimpleField}
 OvcDbSimpleField1.Free;
 OvcDbSimpleField1 := NIL;
 {$ENDIF}
 {$IFDEF UseTOvcDBPictureField}
 OvcDbPictureField1.Free;
 OvcDbPictureField1 := NIL;
 {$ENDIF}
 {$IFDEF UseTOvcDBNumericField}
 OvcDbNumericField1.Free;
 OvcDbNumericField1 := NIL;
 {$ENDIF}
 {$IFDEF UseTDBLookupComboPlus}
 DBLookupComboPlus1.Free;
 DBLookupComboPlus1 := NIL;
 {$ENDIF}
 {$IFDEF UseTDBComboBoxPlus}
 DBComboBoxPlus1.Free;
 DBComboBoxPlus1 := NIL;
 {$ENDIF}
END;

procedure TForm1.bdBorderStyleComboBoxChange(Sender: TObject);
begin
 WITH Sender AS TComboBox DO
  BEGIN
   SpeciesDBEdit.BorderStyle := TBorderStyle(ItemIndex);
   DBMemo1.BorderStyle	     := TBorderStyle(ItemIndex);
   DBImage1.BorderStyle      := TBorderStyle(ItemIndex);
   BlobMRO.BorderStyle	     := TBorderStyle(ItemIndex)
  END;
{BlobMRO.Invalidate}
end;

procedure TForm1.xdLabelTransparentCheckBoxClick(Sender: TObject);
begin
 WITH Sender AS TCheckBox DO
  BEGIN
   OrderNoLabel.Transparent := Checked;
   CompanyLabel.Transparent := Checked;
   EmployeeLabel.Transparent:= Checked;
   TermsLabel.Transparent   := Checked;
   PaymentLabel.Transparent := Checked
  END;
 BoxMRO.Invalidate
end;

procedure TForm1.xdLabelAccelCharCheckBox2Click(Sender: TObject);
begin
 WITH Sender AS TCheckBox DO
  BEGIN
   OrderNoLabel.ShowAccelChar := Checked;
   CompanyLabel.ShowAccelChar := Checked;
   EmployeeLabel.ShowAccelChar:= Checked;
   TermsLabel.ShowAccelChar   := Checked;
   PaymentLabel.ShowAccelChar := Checked;
  END;
 BoxMRO.Invalidate
end;

procedure TForm1.bdMemoWordWrapCheckBoxClick(Sender: TObject);
begin
 DBMemo1.WordWrap := (Sender AS TCheckBox).Checked;
 BlobMRO.Invalidate
end;

procedure TForm1.bdTextTransparentCheckBoxClick(Sender: TObject);
begin
 CommonNameDBText.Transparent := (Sender AS TCheckBox).Checked;
 BlobMRO.Invalidate
end;

procedure TForm1.BlobRecordPanelClick(Sender: TObject);
begin
 IF SpeciesDBEdit.Enabled THEN SpeciesDBEdit.SetFocus
end;

{$IFDEF UseTwwDBLookupCombo}
 {$IFDEF UseTDBLookupComboPlus}
  {$IFDEF UseTDBComboBoxPlus}
   {$IFDEF UseTOvcDBSimpleField}
    {$IFDEF UseTOvcDBPictureField}
     {$IFDEF UseTOvcDBNumericField}
      {$DEFINE AllThirdParty}
     {$ENDIF}
    {$ENDIF}
   {$ENDIF}
  {$ENDIF}
 {$ENDIF}
{$ENDIF}

{$IFNDEF UseTwwDBLookupCombo}
 {$IFNDEF UseTDBLookupComboPlus}
  {$IFNDEF UseTDBComboBoxPlus}
   {$IFNDEF UseTOvcDBSimpleField}
    {$IFNDEF UseTOvcDBPictureField}
     {$IFNDEF UseTOvcDBNumericField}
      {$IFNDEF UseInfoPower}
       {$DEFINE NoThirdParty}
      {$ENDIF}
     {$ENDIF}
    {$ENDIF}
   {$ENDIF}
  {$ENDIF}
 {$ENDIF}
{$ENDIF}

procedure TForm1.Notebook1PageChanged(Sender: TObject);
CONST	  iThird : STRING = 'Only those third party tools that are installed ' +
			    'will appear on the form';
	  iSlow  : STRING = 'This page is created at run time, so it ' +
			    'draws a bit slowly when first viewed';
	  iPlusNT: STRING = 'TDBLookupComboPlus mis-positions its drop down ' +
			    'button under WinNT when compiled under Delphi ' +
			    '2.0.  See README.2xx for more details';

 {$IFDEF WIN32}
 PROCEDURE SwapControls;
 BEGIN
  {$IFDEF UseTDBLookupComboBox}
  IF DBLookupComboBox1 = NIL THEN
   BEGIN
    DBLookupComboBox1 := TDBLookupComboBox.Create(Self);
    WITH DBLookupCombo1 DO
     BEGIN
      DBLookupComboBox1.Parent	   := Parent;
      DBLookupComboBox1.Hint	   := 'TDBLookupComboBox';
      DBLookupComboBox1.DataSource := DataSource;
      DBLookupComboBox1.DataField  := DataField;
      DBLookupComboBox1.ListSource := LookupSource;
      DBLookupComboBox1.ListField  := LookupDisplay;
      DBLookupComboBox1.KeyField   := LookupField;
      DBLookupComboBox1.Top	   := Top;
      DBLookupComboBox1.Left	   := Left;
      DBLookupComboBox1.Width	   := Width;
      DBLookupComboBox1.Height	   := Height;
      DBLookupComboBox1.Font	   := Font;
      DBLookupComboBox1.TabOrder   := TabOrder;
     END;
    DBLookupCombo1.Free;
    DBLookupCombo1 := NIL
   END;
  {$ENDIF}
  {$IFDEF UseTDBLookupListBox}
  IF DBLookupListBox1 = NIL THEN
   BEGIN
    WITH xdLookupListLabel DO Caption := Caption + 'Box';
    DBLookupListBox1 := TDBLookupListBox.Create(Self);
    WITH DBLookupList1 DO
     BEGIN
      DBLookupListBox1.Parent	  := Parent;
      DBLookupListBox1.Hint	  := 'TDBLookupListBox';
      DBLookupListBox1.DataSource := DataSource;
      DBLookupListBox1.DataField  := DataField;
      DBLookupListBox1.ListSource := LookupSource;
      DBLookupListBox1.ListField  := LookupDisplay;
      DBLookupListBox1.KeyField   := LookupField;
      DBLookupListBox1.Top	  := Top;
      DBLookupListBox1.Left	  := Left;
      DBLookupListBox1.Width	  := Width;
      DBLookupListBox1.Height	  := Height;
      DBLookupListBox1.Font	  := Font;
      DBLookupListBox1.TabOrder   := TabOrder;
     END;
    DBLookupList1.Free;
    DBLookupList1 := NIL
   END;
  {$ENDIF}
 END;
{$ENDIF}

begin
 {* Having so many controls share the same DataSources causes some odd	*}
 {* problems.  So we simply turn things off when they are not visible	*}
 MainMRO.DataSource  := NIL;
 BoxMRO.DataSource   := NIL;
 BlobMRO.DataSource  := NIL;
 ThirdMRO.DataSource := NIL;
 CustomerTable.IndexFieldNames := 'CustNo';
 {$IFDEF WIN32}
 SwapControls;
 {$ENDIF}
 {$IFDEF UseTDBLookupComboBox}
 DBLookupComboBox1.ListSource := NIL;
 {$ELSE}
 DBLookupCombo1.LookupSource := NIL;
 {$ENDIF}
 FreeThirdParty;
 WITH Sender AS TNotebook DO
  CASE PageIndex OF
   1 : MainMRO.DataSource := CustomerDataSource;
   2 : BEGIN
	BoxMRO.DataSource := OrdersDataSource;
	{$IFDEF UseTDBLookupComboBox}
	DBLookupComboBox1.ListSource := CustomerDataSource
	{$ELSE}
	DBLookupCombo1.LookupSource := CustomerDataSource
	{$ENDIF}
       END;
   3 : BlobMRO.DataSource := BioLifeDataSource;
   4 : BEGIN
	{$IFNDEF NoThirdParty}
	FYI(iSlow);
	CreateThirdParty;
	{$ENDIF}
	ThirdMRO.DataSource := OrdersDataSource;
	{$IFNDEF AllThirdParty}
	FYI(iThird);
	{$ENDIF}
	{$IFDEF UseTDBLookupComboPlus}
	 {$IFDEF WIN32}
	IF NOT NewStyleControls THEN FYI(iPlusNT);
	 {$ENDIF}
	{$ENDIF}
       END
  END
end;

procedure TForm1.tpCtl3DCheckBoxClick(Sender: TObject);
{$IFDEF UseTDBLookupComboPlus}
CONST iPlus : STRING = 'TDBLookupComboPlus can become blank when Ctl3D is ' +
		       'toggled.  This is not a problem with taDBMRO.  See ' +
		       'README.2xx for more details.';
{$ENDIF}
begin
 WITH Sender AS TCheckBox DO
  BEGIN
   {$IFDEF UseTDBLookupComboPlus}
    {$IFDEF WIN32}
   FYI(iPlus);
    {$ENDIF}
   {$ENDIF}
   ThirdPanel.Ctl3D := Checked;
 { ThirdMRO.Ctl3D := Checked }
  END;
 ThirdMRO.Invalidate
end;

procedure TForm1.tpEnabledCheckBoxClick(Sender: TObject);
begin
 WITH Sender AS TCheckBox DO
  BEGIN
   {$IFDEF UseTwwDBLookupComboPlus}
   wwDBLookupCombo1.Enabled := Checked;
   {$ENDIF}
   {$IFDEF UseInfoPower}
   wwDBComboBox1.Enabled := Checked;
   {$ENDIF}
   {$IFDEF UseTDBLookupComboPlus}
   DBLookupComboPlus1.Enabled := Checked;
   {$ENDIF}
   {$IFDEF UseTDBComboBoxPlus}
   DBComboBoxPlus1.Enabled    := Checked;
   {$ENDIF}
   {$IFDEF UseTOvcDBSimpleField}
   OvcDBSimpleField1.Enabled  := Checked;
   {$ENDIF}
   {$IFDEF UseTOvcDBPictureField}
   OvcDBPictureField1.Enabled := Checked;
   {$ENDIF}
   {$IFDEF UseTOvcDBNumericField}
   OvcDBNumericField1.Enabled := Checked;
   {$ENDIF}
  END;
 ThirdMRO.Invalidate
end;

procedure TForm1.tpBorderStyleComboBoxChange(Sender: TObject);
begin
 WITH Sender AS TComboBox DO
  BEGIN
   {$IFDEF UseTwwDBLookupCombo}
 { wwDBLookupCombo1.BorderStyle := TBorderStyle(ItemIndex); }
   {$ENDIF}
   {$IFDEF UseInfoPower}
 { wwDBComboBox1.BorderStyle := TBorderStyle(ItemIndex); }
   {$ENDIF}
   {$IFDEF UseTDBLookupComboPlus}
   DBLookupComboPlus1.BorderStyle := TBorderStyle(ItemIndex);
   {$ENDIF}
   {$IFDEF UseTDBComboBoxPlus}
   DBComboBoxPlus1.BorderStyle	  := TBorderStyle(ItemIndex);
   {$ENDIF}
   {$IFDEF UseTOvcDBSimpleField}
   OvcDBSimpleField1.BorderStyle  := TBorderStyle(ItemIndex);
   {$ENDIF}
   {$IFDEF UseTOvcDBPictureField}
   OvcDBPictureField1.BorderStyle := TBorderStyle(ItemIndex);
   {$ENDIF}
   {$IFDEF UseTOvcDBNumericField}
   OvcDBNumericField1.BorderStyle := TBorderStyle(ItemIndex);
   {$ENDIF}
   ThirdMRO.BorderStyle 	  := TBorderStyle(ItemIndex)
  END;
{ThirdMRO.Invalidate}
end;

procedure TForm1.tpColorBtnClick(Sender: TObject);
begin
WITH ColorDialog1 DO
  BEGIN
   Options := [cdPreventFullOpen];
   Color   := clWindow;
   IF Execute THEN
    BEGIN
     {$IFDEF UseTwwDBLookupCombo}
     IF wwDBLookupCombo1 IS TwwDBLookupCombo THEN
      TwwDBLookupCombo(wwDBLookupCombo1).Color := Color;
     {$ENDIF}
     {$IFDEF UseTwwDBLookupComboDlg}
     IF wwDBLookupCombo1 IS TwwDBLookupComboDlg THEN
      TwwDBLookupComboDlg(wwDBLookupCombo1).Color := Color;
     {$ENDIF}
     {$IFDEF UseInfoPower}
     wwDBComboBox1.Color := Color;
     {$ENDIF}
     {$IFDEF UseTDBLookupComboPlus}
     DBLookupComboPlus1.Color := Color;
     {$ENDIF}
     {$IFDEF UseTDBComboBoxPlus}
     DBComboBoxPlus1.Color := Color;
     {$ENDIF}
     {$IFDEF UseTOvcDBSimpleField}
     OvcDBSimpleField1.Color := Color;
     {$ENDIF}
     {$IFDEF UseTOvcDBPictureField}
     OvcDBPictureField1.Color := Color;
     {$ENDIF}
     {$IFDEF UseTOvcDBNumericField}
     OvcDBNumericField1.Color := Color;
     {$ENDIF}
    END
  END;
 ThirdMRO.Invalidate
end;

procedure TForm1.xdCheckBoxJustifyComboBox1Change(Sender: TObject);
CONST iCheckBox : STRING = 'Checkbox left justification only valid when '+
			   'when Ctl3D is False (Win 3.1x only)';
begin
 WITH Sender AS TComboBox DO
  BEGIN
   OrdersTableOrderNo.Alignment := TAlignment(ItemIndex);
   DBCheckBox1.Alignment	:= TAlignment(ItemIndex)
  END;
 BoxMRO.Invalidate;
 {$IFNDEF WIN32}
 IF NOT NewStyleControls THEN FYI(iCheckBox)
 {$ENDIF}
end;

procedure TForm1.BioLifeTableAfterInsert(DataSet: TDataset);
begin
 with DataSet do
  begin
   Post;
   Edit;
   FieldByName('Common_Name').AsString := ' ';
   FieldByName('Common_Name').Clear
  end
end;

procedure TForm1.BioLifeTableBeforePost(DataSet: TDataset);
var i : Integer;
begin
 with DataSet do
  if State = dsEdit then
   begin
    for i := 0 to FieldCount - 1 do
     if not Fields[i].IsNull then exit;
    Delete;
    Abort
   end
end;

procedure TForm1.tpHideButtonCheckBoxClick(Sender: TObject);
CONST	  iSpeed : STRING = 'TwwDBComboBox cannot hide it'#39's button';
begin
 FYI(iSpeed);
 WITH Sender AS TCheckBox DO
  BEGIN
     {$IFDEF UseTwwDBLookupCombo}
     wwDBLookupCombo1.ShowButton := NOT Checked;
     {$ENDIF}
     {$IFDEF UseTDBLookupComboPlus}
     DBLookupComboPlus1.ShowSpeedButton := NOT Checked;
     {$ENDIF}
     {$IFDEF UseTDBComboBoxPlus}
     DBComboBoxPlus1.ShowSpeedButton := NOT Checked;
     {$ENDIF}
  END;
 ThirdMRO.Invalidate
end;

procedure TForm1.tpFontBtnClick(Sender: TObject);
begin
 WITH FontDialog1 DO
  BEGIN
   Font := ThirdPanel.Font;
   IF Execute THEN
    BEGIN
     {$IFDEF UseTOvcDBSimpleField}
     OvcDBSimpleField1.ParentFont := TRUE;
     {$ENDIF}
     {$IFDEF UseTOvcDBPictureField}
     OvcDBPictureField1.ParentFont := TRUE;
     {$ENDIF}
     {$IFDEF UseTOvcDBNumericField}
     OvcDBNumericField1.ParentFont := TRUE;
     {$ENDIF}
     ThirdPanel.Font := Font
    END
  END;
 ThirdMRO.Perform(CM_FontChanged,0,0);
 ThirdMRO.Invalidate
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
{$IFDEF WIN32}
Caption := '32 Bit ' + Caption;
{$ELSE}
Caption := '16 Bit ' + Caption;
{$ENDIF}
end;

begin
 IF NOT CheckForTables THEN HALT
end.
